#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use Test::More;
use Log::Any::Test;
use Log::Any qw/$log/;
use lib::abs('../lib');
use JSON;
use Yandex::Trace;
use Time::HiRes qw/sleep/;

if (!$ENV{YANDEX_TRACE_REAL_SLEEP}) {
    plan skip_all => "test requires YANDEX_TRACE_REAL_SLEEP=1 ";
}

do(lib::abs::path('.')."/_test_common.pl");

my $trace = Yandex::Trace->new(service => 'test', method => 'real_sleep');

my $t = Yandex::Trace::new_profile('sleep');
sleep(1.333);
undef $t;
$trace->flush();

my $res = get_last_log();
ok(abs($res->[14]->{profile}->[0]->[2] - 1.333) < 0.001, "sleep");

done_testing();



