#!/usr/bin/perl

use strict;
use warnings;
use Test::More;
use Test::MockTime qw(:all);
use Log::Any::Test;
use Log::Any qw/$log/;
use JSON;

use lib::abs '../lib';

do(lib::abs::path('.').'/_test_common.pl');

BEGIN { use_ok('Yandex::Trace', qw/current_trace $INDEX $PROFILE_INDEX/) };

mock_hires();
set_fixed_time(time);

my $EPS = 0.001;

{
my $trace = Yandex::Trace->new(method => 'rest', service => 'test');

my $t = Yandex::Trace::new_profile('sleep');
test_sleep(5);
undef $t;
test_sleep(2);
$trace->flush();

my $res = get_last_log();
my $profile = $res->[14]->{profile};

ok(scalar @$profile == 2, "number of records in profile");
ok($profile->[1]->[0] eq 'rest', "got rest");
ok($profile->[1]->[2] == 2, "correct rest duration");
}

{
my $trace = Yandex::Trace->new(service => 'test', method => 'rest');

my $t = Yandex::Trace::new_profile('sleep');
test_sleep(100);
undef $t;
test_sleep(1);
$trace->flush();
my $res = get_last_log();
my $profile = $res->[14]->{profile};

ok(scalar @$profile == 1, "no rest if less than 90% of time");
ok($profile->[0]->[0] eq 'sleep');
}

done_testing();
