#!/usr/bin/perl

use strict;
use warnings;
use Test::More;
use Log::Any::Test;
use Log::Any qw/$log/;
use JSON;

use lib::abs '../lib';

do(lib::abs::path('.').'/_test_common.pl');
mock_hires();

BEGIN { use_ok('Yandex::Trace', qw/current_trace $INDEX $PROFILE_INDEX/) };


my $trace = Yandex::Trace->new(method => 'test', service => 'test', tags => 'first');

ok($trace->tags() eq 'first');

Yandex::Trace::restart(\$trace, tags => 'snd');

my $r = get_last_log();
ok($r->[$INDEX->{TAGS}] eq 'first');

ok($trace->tags() eq 'snd');

$trace->flush();
undef $trace;

$r = get_last_log();

ok($r->[$INDEX->{TAGS}] eq 'snd');

{
    my $trace = Yandex::Trace->new(service => 'test', method => 'test');
    my $p = Yandex::Trace::new_profile('first');
    Yandex::Trace::restart(\$trace, tags => 'hi!');
    my $p2 = Yandex::Trace::new_profile('snd');
}

{
    my $trace = Yandex::Trace->new(service => 'test', method => 'test');
    for (1 .. 5) {
        my $p = Yandex::Trace::new_profile('xxx');
        test_sleep(5);
        undef $p;
        Yandex::Trace::restart(\$trace);
        my $r = get_last_log();
        my ($rest) = grep { $_->[0] eq 'rest' } @{$r->[14]->{profile}};
        ok(!$rest || $rest->[2] < 0.1, "no rest after restart");
    }

}

done_testing();


