#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use lib::abs('../../lib');
use Log::Any::Adapter;
use Yandex::Log;
use File::Temp qw/tempdir/;
use Test::MockTime qw/:all/;
use Yandex::Trace qw/current_trace/;

set_fixed_time(time);

do(lib::abs::path('..')."/_test_common.pl");
mock_hires();
# { use Data::Dump 'pp'; my $p = pp({ env => \%ENV }); $p =~ s#\\x\{([\da-f]{2,4})\}#chr(hex($1))#gei; print STDERR "$p\n"; } # NO_PRODUCTION

my $log_dir = tempdir('yandex_log_XXXXXX', CLEANUP => 0, DIR => '/tmp');

$Yandex::Log::LOG_ROOT = $log_dir;

$Yandex::Trace::LOG_OPTIONS = {
    log_file_name => 'trace_child.log',
};

my $trace = Yandex::Trace::new_from_env(service => 'test', method => 'child');

my $t = Yandex::Trace::new_profile('child_sleep');
test_sleep(5);

print "$log_dir/trace_child.log\n";
