#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use lib::abs('../../lib');
use Log::Any::Adapter;
use Yandex::Log;
use File::Temp qw/tempdir/;
use Test::MockTime qw/:all/;
use Yandex::Trace;

set_fixed_time(time);

do(lib::abs::path('..')."/_test_common.pl");
mock_hires();

my $log_dir = tempdir('yandex_log_XXXXXX', CLEANUP => 0, DIR => '/tmp');

$Yandex::Log::LOG_ROOT = $log_dir;
$Yandex::Trace::LOG_OPTIONS = {
    log_file_name => 'trace.log',
};

# my $trace = Yandex::Trace->new(service => 'test', method => 'example');
my $trace = Yandex::Trace::new_from_env(service => 'test', method => 'example');
my $t = Yandex::Trace::new_profile('test_func');
test_sleep(1);
print "$log_dir/trace.log\n";

=head1 TEST_DATA

[3,"2015-03-06 14:21:42.0.095566987991333","ppcdev2.yandex.ru",9060,"test","example","",8758874657280788175,0,8758874657280788175,1,true,0.00031590461730957,1,{"times":[0.06,0,0,0],"profile":[["test_func","",1,0,1,0]],"services":[],"marks":[],"annotations":[]}]

=cut
