#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use lib::abs('../../lib');
use Log::Any::Adapter;
use Yandex::Log;
use File::Temp qw/tempdir/;
use Test::MockTime qw/:all/;
use Yandex::Trace qw/current_trace/;

set_fixed_time(time);

my $cwd = lib::abs::path('.');

do("$cwd/../_test_common.pl");
mock_hires();

my $log_dir = tempdir('yandex_log_XXXXXX', CLEANUP => 0, DIR => '/tmp');

$Yandex::Log::LOG_ROOT = $log_dir;

$Yandex::Trace::LOG_OPTIONS = {
    log_file_name => 'trace_fork.log',
};
my $trace = Yandex::Trace->new(service => 'test', method => 'fork');

my $service = Yandex::Trace::new_service('test', 'fork');

if (my $pid = fork) {
    my $t = Yandex::Trace::new_profile('wait_sleep');
    test_sleep(10);
    wait;
}
else {
    $trace = Yandex::Trace::restart(\$trace);
    undef $service;
    my $child_log = `$cwd/child.pl`;
    chomp $child_log;
    my $t = Yandex::Trace::new_profile('fork_sleep');
    test_sleep(7);
    print "child: $child_log\n";
    exit;
}

my $t2 = Yandex::Trace::new_profile('parent_sleep');
test_sleep(5);

print "$log_dir/trace_fork.log\n";
