#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use lib::abs('../../lib');
use Log::Any::Adapter;
use Yandex::Log;
use File::Temp qw/tempdir/;
use Yandex::Trace;
use Path::Tiny;


package Another::Log::User {
    use Log::Any;
    sub new {
        my ($class) = @_;
        my $self = {
            log => Log::Any->get_logger(category => 'another'),
        };
        return bless $self, $class;
    }
    sub test_call {
        my $self = shift;
        $self->{log}->info("this is a message from Another::Log::User");
    }
}

my $another = Another::Log::User->new();

my $log_dir = tempdir('yandex_log_XXXXXX', CLEANUP => 0, DIR => '/tmp');

$Yandex::Log::LOG_ROOT = $log_dir;

Log::Any::Adapter->set({ category => 'trace' },  'YandexLog', no_date => 1, log_file_name => 'trace.log');
Log::Any::Adapter->set({ category => 'another' },'YandexLog', log_file_name => 'another.log'); 

$another->test_call();

my $trace = Yandex::Trace->new(service => 'test', method => 'log');
undef $trace;

my @logs = path($log_dir)->children();
print ''.(join "\n", @logs)."\n";
