#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use lib::abs('../../lib');
use Log::Any::Adapter;
use Yandex::Log;
use File::Temp qw/tempdir/;
use Test::MockTime qw/:all/;
use Yandex::Trace;
use Path::Tiny;

set_fixed_time(time);

do(lib::abs::path('..')."/_test_common.pl");
mock_hires();

my $cwd = lib::abs::path('.');

path($cwd, "trace.log")->remove;

$Yandex::Log::LOG_ROOT = $cwd;
$Yandex::Trace::LOG_OPTIONS = {
    log_file_name => 'trace.log',
    no_date => 1,
};

my $trace = Yandex::Trace->new(service => 'test', method => 'smart_flush');
my $p1 = Yandex::Trace::new_profile('p1');
test_sleep(100);

my $p3 = Yandex::Trace::new_profile('p3');
test_sleep(1);
undef $p3;

my $p4 = Yandex::Trace::new_profile('p4');
test_sleep(3);
undef $p4;

my $p2 = Yandex::Trace::new_profile('p2');
test_sleep(200);
undef $p2;

undef $p1;
undef $trace;
