#!/usr/bin/perl

use strict;
use warnings;
# use Test::More skip_all => 'not ready yet';
use Test::More;
use Test::MockTime qw(:all);
use Log::Any::Test;
use Log::Any qw/$log/;
use JSON;
use Path::Tiny;

use lib::abs '../lib';

do(lib::abs::path('.').'/_test_common.pl');

BEGIN { use_ok('Yandex::Trace', qw/current_trace $INDEX $PROFILE_INDEX/) };

my $trace = Yandex::Trace->new(service => 'test', method => 'system');

my $s = Yandex::Trace::new_service('test', 'system');
{
    local $ENV{YANDEX_TRACE} = join ',', $s->get_service_ids();
    my $cmd = lib::abs::path('.')."/script/example.pl";
    my $log_file = `$cmd`;
    $log_file =~ s!\s!!g;
    my $log = path($log_file)->slurp_utf8();
    my ($date, $time, $json) = split /\s+/, $log, 3;
    my $data = from_json($json);
    ok($data->[0] == 3, "format_id");
    ok($data->[$INDEX->{PARENT_ID}] == current_trace()->span_id, "parent -> span");
    ok($data->[$INDEX->{TRACE_ID}] == current_trace()->trace_id, "trace -> trace");
}
undef $s;
$trace->flush();
my $r = get_last_log();
my $srv = $r->[$INDEX->{DATA}]->{services};
ok(scalar @$srv == 1, "service count");
ok($srv->[0]->[0] eq 'test', "service service");
ok($srv->[0]->[1] eq 'system', "service method");

done_testing();
