#!/usr/bin/perl
use warnings;
use strict;

use Test::More;
use Test::Exception;
use Yandex::TVM2;

use FindBin qw($Bin);
use lib "$Bin/lib";

# модуль для создания и работы фейкового веб-сервера
use FakeWebServer qw(update_response);

# меняем адрес api на localhost
$Yandex::TVM2::API_URL = "http://127.0.0.1:$FakeWebServer::port/ticket";

update_response('{"1":{"ticket":"3:serv:CJk"}, "2":{"ticket":"3:serv:EJk"}}');

my $pwd = $0;
$pwd =~ s!(^|/)[^\/]*$!$1!;
$Yandex::TVM2::SECRET_PATH = $pwd."/files_for_test/secret.txt";
$Yandex::TVM2::APP_ID = "2000086";

Yandex::TVM2::get_tickets([1, 2]);

update_response('{"1":{"ticket":"3:serv:QJk"}}');

is_deeply (Yandex::TVM2::get_tickets([1, 2]), {'1' => '3:serv:CJk', '2' => '3:serv:EJk'}, 'Check cached dst');

Yandex::TVM2::clear_tickets_cache();

dies_ok{Yandex::TVM2::get_ticket(2)} 'Cache cleared';

is_deeply (Yandex::TVM2::get_tickets([1]), {'1' => '3:serv:QJk'}, 'Check new ticket was obtained');

done_testing();
