#!/usr/bin/perl
use warnings;
use strict;

use Test::More;
use Test::Exception;
use Yandex::TVM2;

use FindBin qw($Bin);
use lib "$Bin/lib";

# модуль для создания и работы фейкового веб-сервера
use FakeWebServer qw(update_response);

# меняем адрес api на localhost
$Yandex::TVM2::API_URL = "http://127.0.0.1:$FakeWebServer::port/ticket";

update_response('{"1":{"ticket":"3:serv:CJk"}, "2":{"ticket":"3:serv:EJk"}}');

my $pwd = $0;
$pwd =~ s!(^|/)[^\/]*$!$1!;
$Yandex::TVM2::SECRET_PATH = $pwd."/files_for_test/secret.txt";
$Yandex::TVM2::APP_ID = "2000086";

is_deeply (Yandex::TVM2::_get_new_tvm2_tickets([1, 2]), {'1' => '3:serv:CJk', '2' => '3:serv:EJk'}, 'Simple check get new tickets');

update_response('{"1":{"ticket":"3:serv:CJk"}}');
is_deeply (Yandex::TVM2::_get_new_tvm2_tickets([1]), {'1' => '3:serv:CJk'}, 'Check one dst');

update_response('{"1":{"ticket":"3:serv:CJk"}, "2":{"error":"test Error"}}');
dies_ok{Yandex::TVM2::_get_new_tvm2_tickets([1, 2])} 'Dies with bad response';

dies_ok{Yandex::TVM2::_get_new_tvm2_tickets([30])} 'Dies with no id in response';

update_response('{"1":{"ticket":"3:serv:CJk"}, "2":{"ticket":"3:serv:EJk"}}}');
dies_ok{Yandex::TVM2::_get_new_tvm2_tickets([1, 2])} 'Dies with mallformed json';

update_response('');
dies_ok{Yandex::TVM2::_get_new_tvm2_tickets([1, 2])} 'Dies with no response';

update_response('{"1":{"ticket":"3:serv:CJk"}, "2":{"ticket":"3:serv:EJk"}}}');
dies_ok{Yandex::TVM2::_get_new_tvm2_tickets([1, 2])} 'Dies with no success';
done_testing();