#!/usr/bin/perl
use warnings;
use strict;

use Test::More;
use Test::Exception;
use Yandex::TVM2;

use FindBin qw($Bin);
use lib "$Bin/lib";

# модуль для создания и работы фейкового веб-сервера
use FakeWebServer qw(update_response);

# меняем адрес api на localhost
$Yandex::TVM2::API_URL = "http://127.0.0.1:$FakeWebServer::port/ticket";

update_response(sub { my ( $self, $got_request ) = @_; $got_request; });

my $pwd = $0;
$pwd =~ s!(^|/)[^\/]*$!$1!;

$Yandex::TVM2::APP_ID = undef;
dies_ok{Yandex::TVM2::_get_parsed_json_response_from_tvm2([1, 2])} "Dies without application id";

$Yandex::TVM2::APP_ID = "2000086";
$Yandex::TVM2::SECRET_PATH = undef;
dies_ok{Yandex::TVM2::_get_parsed_json_response_from_tvm2([1, 2, 3])} "Dies without SECRET_PATH";

$Yandex::TVM2::SECRET_PATH = $pwd."/files_for_test/not_existent_file.txt";
dies_ok{Yandex::TVM2::_get_parsed_json_response_from_tvm2([1, 2])} "Dies when file with secret not exists";

$Yandex::TVM2::SECRET_PATH = $pwd."/files_for_test/empty_file.txt";
dies_ok{Yandex::TVM2::_get_parsed_json_response_from_tvm2([1, 2])} "Dies with empty secret file";

$Yandex::TVM2::SECRET_PATH = $pwd."/files_for_test/secret.txt";
update_response(sub{'{"1":{"ticket":"3:serv:CJk"}, "2":{"ticket":"3:serv:EJk"}'});
dies_ok{Yandex::TVM2::_get_parsed_json_response_from_tvm2([1, 2])} "Dies with mallformed json";

update_response('{"1":{"ticket":"3:serv:CJk"}, "2":{"ticket":"3:serv:EJk"}}');
is_deeply (Yandex::TVM2::_get_parsed_json_response_from_tvm2([1, 2]), {"1" => {"ticket" => "3:serv:CJk"}, "2" => {"ticket" => "3:serv:EJk"}}, 'Simple check common case');

$Yandex::TVM2::APP_ID = undef;
dies_ok{Yandex::TVM2::_get_parsed_json_response_from_tvm2([1, 2])} "Dies without application id with SECRET_PATH";

done_testing();