#!/usr/bin/perl
use warnings;
use strict;

use Test::More;
use Test::MockTime qw(:all);
use Yandex::TVM2;

use FindBin qw($Bin);
use lib "$Bin/lib";

# модуль для создания и работы фейкового веб-сервера
use FakeWebServer qw(update_response);

# меняем адрес api на localhost
$Yandex::TVM2::API_URL = "http://127.0.0.1:$FakeWebServer::port/ticket";

my $pwd = $0;
$pwd =~ s!(^|/)[^\/]*$!$1!;
$Yandex::TVM2::SECRET_PATH = $pwd."/files_for_test/secret.txt";
$Yandex::TVM2::APP_ID = "2000086";

update_response('{"1":{"ticket":"3:serv:CJk"}}');
is(Yandex::TVM2::get_ticket(1), '3:serv:CJk', 'Check one ticket obtained');

update_response('{"3":{"ticket":"3:serv:RRJk"}}');
is(Yandex::TVM2::get_ticket(3), '3:serv:RRJk', 'Check another ticket obtained');

update_response('{"1":{"ticket":"3:serv:WE12Jk"}}');
is(Yandex::TVM2::get_ticket(1), '3:serv:CJk', 'Check ticket cached');

is(Yandex::TVM2::get_ticket(1, {scopes => 'scope1'}), '3:serv:WE12Jk', 'Check ticket with another scope obtained');

update_response('{"1":{"ticket":"3:serv:NEWJk"}}');
is(Yandex::TVM2::get_ticket(1, {scopes => 'scope1'}), '3:serv:WE12Jk', 'Check ticket with another scope cached');

set_fixed_time(time + 51 * 60);
update_response('{"1":{"ticket":"3:serv:QJk"}}');
is(Yandex::TVM2::get_ticket(1, {scopes => ''}), '3:serv:QJk', 'Ticket expired, got new ticket');

update_response('{"1":{"ticket":"3:serv:TRJk"}}');
is(Yandex::TVM2::get_ticket(1, {cache_enabled => 0}), '3:serv:TRJk', 'Got ticket without cache');

done_testing();