#!/usr/bin/perl
use warnings;
use strict;

use Test::More;
use Test::MockTime qw(:all);
use Yandex::TVM2;

use FindBin qw($Bin);
use lib "$Bin/lib";

# модуль для создания и работы фейкового веб-сервера
use FakeWebServer qw(update_response);

# меняем адрес api на localhost
$Yandex::TVM2::API_URL = "http://127.0.0.1:$FakeWebServer::port/ticket";

my $pwd = $0;
$pwd =~ s!(^|/)[^\/]*$!$1!;
$Yandex::TVM2::SECRET_PATH = $pwd."/files_for_test/secret.txt";
$Yandex::TVM2::APP_ID = "2000086";

update_response('{"1":{"ticket":"3:serv:CJk"}}');
is_deeply(Yandex::TVM2::get_tickets(), {}, 'Check empty request');

update_response('{"3":{"ticket":"3:serv:RRJk"}}');
is_deeply(Yandex::TVM2::get_tickets([3]), {3 => '3:serv:RRJk'}, 'Check one ticket request');

update_response('{"3":{"ticket":"3:serv:aaaJk"}}');
is_deeply(Yandex::TVM2::get_tickets([3], {scopes => 'scope2'}), {3 => '3:serv:aaaJk'}, 'Check ticket with scopes obtained');

update_response('{"3":{"ticket":"3:serv:bbbJk"}}');
is_deeply(Yandex::TVM2::get_tickets([3], {scopes => 'scope2'}), {3 => '3:serv:aaaJk'}, 'Check ticket with scopes cached');

is_deeply(Yandex::TVM2::get_tickets([3]), {3 => '3:serv:RRJk'}, 'Check one ticket cached');

update_response('{"1":{"ticket":"3:serv:QJk"}}');

my $ts = time;

set_fixed_time($ts + 30 * 60);
is_deeply(Yandex::TVM2::get_tickets([1, 3]), {1 => '3:serv:QJk', 3 => '3:serv:RRJk'}, 'Check two ticket request');

set_fixed_time($ts + 61 * 60);
update_response('{"3":{"ticket":"3:serv:aaa"}}');
is_deeply(Yandex::TVM2::get_tickets([1, 3], {scopes => ''}), {1 => '3:serv:QJk', 3 => '3:serv:aaa'}, 'One ticket expired');

update_response('{"3":{"ticket":"3:serv:EEIk"}, "1":{"ticket":"3:serv:OEIS"}}');
is_deeply(Yandex::TVM2::get_tickets([1, 3], {cache_enabled => 0}), {1 => '3:serv:OEIS', 3 => '3:serv:EEIk'}, 'Get tickets without cache');

done_testing();