package FakeWebServer;

# микро-сервер на основе HTTP::Server::Simple для тестирования
use Exporter;

{
	package ServerSimple;
 
	use HTTP::Server::Simple::CGI;
	use base qw(HTTP::Server::Simple::CGI);
	
	our $response = '';
 
	sub handle_request {
		my $self = shift;
		my $cgi  = shift;
  
		my $path = $cgi->path_info();
	
		if ($path eq '/ticket') {
			print "HTTP/1.0 200 OK\r\n";
			my $who = $cgi->param('name');
	
			print $cgi->header('application/json');
			print $response; 
		} else {
			print "HTTP/1.0 404 Not found\r\n";
			print $cgi->header,
				$cgi->start_html('Not found'),
				$cgi->h1('Not found'),
				$cgi->end_html;
		}
	}
}

@ISA = qw(Exporter);
our @EXPORT_OK = qw(
    update_response
);

my $pid;
our $port = 7497;

sub update_response
{
	my $response = shift;
	if ($pid) {
		kill -9, $pid;
		sleep 5;
	}
	$ServerSimple::response = $response if $response;
	{
		local *STDOUT;

		open (STDOUT, '>', '/dev/null');
		$pid = ServerSimple->new($port)->background();
	}
}

END {
     if ($pid) {
	kill -9, $pid;
     }
}

1;