#!/usr/bin/perl -w

=pod
    $Id: get_Host.t 19476 2010-12-14 14:06:34Z eboguslavskaya $
=cut

use strict;
use Test::More tests => 12;

BEGIN { use_ok("Yandex::URL"); }

*h = \&Yandex::URL::get_host;

is(h('http://www.ya.ru/'), 'www.ya.ru');
is(h('https://www.ya.ru/'), 'www.ya.ru');
is(h('news://www.ya.ru/'), 'www.ya.ru');
is(h('http://www.ya.ru:234/asdfadsf'), 'www.ya.ru');
is(h('http://www.ya.ru?sdfasdf'), 'www.ya.ru');
is(h('http://www.ya.ru#sdfasdf'), 'www.ya.ru');
is(h('http://www.ya.ru?sdfa#sdf'), 'www.ya.ru');
is(h('http://www.ya.ru#sdfa?sdf'), 'www.ya.ru');
is(h('http://www.ya.ru&sdfasdf'), 'www.ya.ru');
is(h(''), '');
is(h(undef), '');
