#!/usr/bin/perl -w

use strict;
use Test::More;

BEGIN { use_ok("Yandex::URL"); }

my @tests = (
    ['http://www.ya.ru/', 'www.ya.ru/'],
    ['http://www.ya.ru/some_page.html', 'www.ya.ru/some_page.html'],
    ['http://www.ya.ru:234/some_page.html', 'www.ya.ru:234/some_page.html'],
    ['http://www.ya.ru?sdfa#sdf', 'www.ya.ru?sdfa#sdf'],
    ['news://www.ya.ru/some_page.html', 'www.ya.ru/some_page.html'],
    ['www.ya.ru', 'www.ya.ru'],
    ['www.ya.ru?sdfa#sdf', 'www.ya.ru?sdfa#sdf'],
);

foreach my $test (@tests) {
	is(Yandex::URL::strip_protocol($test->[0]), $test->[1]);
}

Test::More::done_testing(scalar (@tests) + 1);

