#!/usr/bin/perl -w

use strict;
use Test::More tests => 10;

BEGIN { use_ok("Yandex::URL"); }

*d = \&Yandex::URL::strip_subdomain;

is(d('ya.ru'),'ru');
is(d('test.ya.ru'),'ya.ru');
is(d('test.ya.ru.'),'ya.ru.');
is(d('test01.test-02.ya.ru'),'test-02.ya.ru');
is(d('www.xn--d1ajencbigbkg.xn--p1ai'),'xn--d1ajencbigbkg.xn--p1ai');
is(d('ru'),'');
is(d('ru.'),'');
is(d(''),'');
is(d(undef),'');

