#!/usr/bin/perl

use strict;
use warnings;

# $Id$

use FindBin;
use lib "$FindBin::Bin/../../lib";

use Test::More;
use Yandex::Validate;

ok( is_valid_id('1'), 'is_valid_id(1)' );
ok( !is_valid_id('0'), 'is_valid_id(0)' );
ok( !is_valid_id('-1'), 'is_valid_id(-1)' );
ok( is_valid_id('4294967296'), 'is_valid_id(4294967296)' );
ok( !is_valid_id("4294967296\n"), 'number with new line' );
ok( is_valid_id('18446744073709551615'), 'is_valid_id(18446744073709551615)' );
ok( !is_valid_id('18446744073709551616'), 'is_valid_id(18446744073709551616)' );
ok( !is_valid_id('5234523452345234523452345'), 'is_valid_id(5234523452345234523452345)' );

ok( !is_valid_id('+123'), 'is_valid_id(+123)' );
ok( !is_valid_id('foobar'), 'is_valid_id(foobar)' );
ok( !is_valid_id('123foobar'), 'is_valid_id(123foobar)' );
ok( !is_valid_id('-123foobar'), 'is_valid_id(-123foobar)' );


done_testing;
