#!/usr/bin/perl

use strict;
use warnings;

# $Id$

use Test::More tests => 19;
use Yandex::Validate;

ok( is_valid_int('1'), 'is_valid_int(1)' );
ok( is_valid_int('0'), 'is_valid_int(0)' );
ok( is_valid_int('-1'), 'is_valid_int(-1)' );
ok( is_valid_int('4294967296'), 'is_valid_int(4294967296)' );
ok( is_valid_int('18446744073709551615'), 'is_valid_int(18446744073709551615)' );

ok( !is_valid_int('+123'), 'is_valid_int(+123)' );
ok( !is_valid_int('foobar'), 'is_valid_int(foobar)' );
ok( !is_valid_int('123foobar'), 'is_valid_int(123foobar)' );
ok( !is_valid_int('-123foobar'), 'is_valid_int(-123foobar)' );

ok( is_valid_int( 1, 0 ), '1 >= 0' );
ok( is_valid_int( 1, 1 ), '1 >= 1' );
ok( is_valid_int( 1, undef, 1 ), '1 <= 1' );
ok( is_valid_int( 1, 0, 3 ), '0 <= 1 <= 3' );
ok( is_valid_int( 1, 1, 1 ), '1 <= 1 <= 1' );

ok( !is_valid_int( -5, 0 ), '-5 >= 0' );
ok( !is_valid_int( -5, 1 ), '-5 >= 1' );
ok( !is_valid_int( 10, undef, 1 ), '10 <= 1' );
ok( !is_valid_int( -5, 0, 3 ), '0 <= -5 <= 3' );
ok( !is_valid_int( -5, 1, 1 ), '1 <= -5 <= 1' );
