#!/usr/bin/perl -w

=pod
    $Id$
    проверка строки на соответствие формату ip
=cut

use strict;

use Test::More;
use Yandex::Validate;

use utf8;
use open ':std' => ':utf8';

*ivi = \&Yandex::Validate::is_valid_ip;

ok(ivi('127.0.0.1'));
ok(ivi('4.2.2.2'));
ok(ivi('14.2.22.2'));
ok(ivi('114.0.22.1'));
ok(!ivi("114.0.22.1\n"));
ok(!ivi('1114.2.22.2'));
ok(!ivi('114.2.22.256'));
ok(!ivi('114.2.22.'));

ok( scalar( map {ivi($_)} qw/4.2.2.2 1.1.1.1 1111.1.1.1/) == 3 );

done_testing;
