#!/usr/bin/env perl
use Direct::Modern;
use JSON qw/from_json/;
use Test::More;
use Yandex::Xiva;

my $CONTENT;
my $message = "\x{432}\x{441}\x{451} \x{43f}\x{440}\x{43e}\x{43f}\x{430}\x{43b}\x{43e}";

no warnings 'redefine';
local *Yandex::Xiva::http_parallel_request = sub {
    my (undef, $data) = @_;
    $CONTENT = $data->{1};
    my $result = {};
    $result->{1}->{headers}->{Status} = 200;
    return $result;
};
local *Yandex::Xiva::_dispatch_token = sub {
    return "Z";
};
local *Yandex::Log::out = sub {};
local *Yandex::Log::Messages::new = sub {return bless({}, 'Yandex::Log')};

xiva_send_messages([{
    uid => 1,
    message => $message,
    payload => {C => 300, T => 90},
    tag => "XXXX",
}]);
is($CONTENT->{headers}->{'Content-Type'}, 'application/json; charset=utf-8', "Content-Type is right");
ok($CONTENT->{url} =~ 'Type_90', "Message type is right (Type_90)");
my $body = from_json($CONTENT->{body});
if ($body->{repack}->{gcm}->{repack_payload}) {
    $body->{repack}->{gcm}->{repack_payload} = [sort @{$body->{repack}->{gcm}->{repack_payload}}];
}
if ($body->{repack}->{apns}->{repack_payload}) {
    $body->{repack}->{apns}->{repack_payload} = [sort @{$body->{repack}->{apns}->{repack_payload}}];
}
is_deeply(
    $body,
    {
        'repack' => {
            'gcm' => {
                'repack_payload' => [
                    'C',
                    'T',
                    'text'
                ]
            },
            'apns' => {
                'repack_payload' => [
                    'C',
                    'T'
                ],
                'aps' => {
                    'alert' => $message,
                    'content-available' => 1
                }
            }
        },
        'payload' => {
            'T' => '90',
            'text' => $message,
            'C' => 300
        },
        'subscriptions' => [{
            'device' => ['XXXX']
        }]
    },
    "Message body is right (tag as device in subscriptions)"
);

xiva_send_messages([{
    uid => 1,
    message => $message,
    payload => {T => 34},
    device_id => "BBBB",
}]);
$body = from_json($CONTENT->{body});
if ($body->{repack}->{gcm}->{repack_payload}) {
    $body->{repack}->{gcm}->{repack_payload} = [sort @{$body->{repack}->{gcm}->{repack_payload}}];
}
is_deeply(
    $body,
    {
        'repack' => {
            'gcm' => {
                'repack_payload' => [
                    'T',
                    'text'
                ]
            },
            'apns' => {
                'repack_payload' => [
                    'T'
                ],
                'aps' => {
                    'alert' => $message,
                    'content-available' => 1
                }
            }
        },
        'payload' => {
            'T' => '34',
            'text' => $message
        },
        'subscriptions' => [{
            'device' => ['BBBB']
        }]
    },
    "Message body is right (device in subscriptions)"
);

my $category = 'PAYMENT_AND_STATS';

xiva_send_messages([{
    uid => 1,
    message => $message,
    payload => {T => 34, category => $category},
    device_id => "BBBB",
}]);
$body = from_json($CONTENT->{body});
if ($body->{repack}->{gcm}->{repack_payload}) {
    $body->{repack}->{gcm}->{repack_payload} = [sort @{$body->{repack}->{gcm}->{repack_payload}}];
}
is_deeply(
    $body,
    {
        'repack' => {
            'gcm' => {
                'repack_payload' => [
                    'T',
                    'category',
                    'text'
                ]
            },
            'apns' => {
                'repack_payload' => [
                    'T'
                ],
                'aps' => {
                    'alert' => $message,
                    'category' => $category,
                    'content-available' => 1
                }
            }
        },
        'payload' => {
            'category' => $category,
            'T' => '34',
            'text' => $message
        },
        'subscriptions' => [{
            'device' => ['BBBB']
        }]
    },
    "Message body is right (category in payload and aps)"
);

done_testing();
