#!/usr/bin/env perl
use Direct::Modern;
use JSON qw/from_json/;
use Test::More;
use Yandex::Xiva;

my $CONTENT;

no warnings 'redefine';
local *Yandex::Xiva::http_parallel_request = sub {
    my (undef, $data) = @_;
    $CONTENT = $data->{1};
    my $result = {};
    $result->{1}->{headers}->{Status} = 200;
    return $result;
};
local *Yandex::Xiva::_subscription_token = sub {
    return "Z";
};
local *Yandex::Log::out = sub {};
local *Yandex::Log::Messages::new = sub {return bless({}, 'Yandex::Log')};

xiva_subscribe(
    uid => 1,
    client => undef,
    uuid => "XXXX",
    platform => 'GCM',
    push_token => 'CCCC',
    tag => 'YYYY',
);
is($CONTENT->{headers}->{'Content-Type'}, 'application/x-www-form-urlencoded; charset=utf-8', "Content-Type is right");
ok($CONTENT->{url} =~ 'client=ru.yandex.direct.unknown', "Client is right (default)");
ok($CONTENT->{url} =~ 'service=direct(?:&|$)', "Service is right (without tag)");
ok($CONTENT->{url} =~ 'device=YYYY', "Device is right (copied from tag)");
ok(!exists $CONTENT->{body}->{filter},
    'there is no more filter'
);

xiva_subscribe(
    uid => 1,
    client => 'ru.yandex.direct.inhouse',
    uuid => "XXXX",
    platform => 'GCM',
    push_token => 'CCCC',
    device_id => 'BB-BB',
);
ok($CONTENT->{url} =~ 'client=ru.yandex.direct.inhouse', "Client is right (ru.yandex.direct.inhouse)");
ok($CONTENT->{url} =~ 'service=direct(?:&|$)', "Service is right (without tag)");
ok($CONTENT->{url} =~ 'device=BB-BB', "Device is right");

done_testing();
