package Yandex::XMLRPC::UTF8Serializer;

use strict;
use utf8;

use XMLRPC::Lite;
@Yandex::XMLRPC::UTF8Serializer::ISA = 'XMLRPC::Serializer';

use Encode qw//;

sub new {
    my $class = shift;
    my $enc = shift;
    if ( !$enc && ref $class ) { $enc = $class->{yandex_encoding}; }
    if ( !$enc ) { $enc = 'utf8'; }
    my $self = $class->SUPER::new( @_ );
    $self->{yandex_encoding} = $enc;
    # строчки с флагом utf должны передаваться как строки, независимо от содержимого
    $self->{_typelookup}{utf8_string} = [0, sub { Encode::is_utf8($_[0]) }, 'as_string'];
    bless $self;
}

sub encode_scalar {
    my($self, $value, $name, $type, $attr) = @_;
    if ( !ref $value ) {
        $value = Encode::encode( $self->{yandex_encoding}, $value );
    }
    return $self->SUPER::encode_scalar( $value, $name, $type, $attr );
}

# убрать base64 из списка автоопределяемых типов данных 
sub disable_base64 {
    my ($self) = @_;
    delete $self->{_typelookup}->{base64};
    return $self;
}

# опасные символы; взято из Frontier::RPC2
our %char_entities = (
    '&' => '&amp;',
    '<' => '&lt;',
    '>' => '&gt;',
    '"' => '&quot;',
);

# utf8-safe версия
sub as_string {
    my($self, $value) = @_;
    # заменяем служебные символы на безопасные аналоги ;-)
    $value =~ s/([&<>\"])/$char_entities{$1}/ge;
    # всё что длиннее чем 7 бит, передаём в числовом виде
    $value =~ s/([\x{80}-\x{FFFF}])/'&#' . ord($1) . ';'/gse;
    return ['string', {}, $value];
}

1;

package Yandex::XMLRPC::UTF8Deserializer;

use strict;

use XMLRPC::Lite;

@Yandex::XMLRPC::UTF8Deserializer::ISA = 'XMLRPC::Deserializer';

use Encode qw//;

sub new {
    my $class = shift;
    my $enc = shift;
    if ( !$enc && ref $class ) { $enc = $class->{yandex_encoding}; }
    if ( !$enc ) { $enc = 'utf8'; }
    my $self = $class->SUPER::new( @_ );
    $self->{yandex_encoding} = $enc;
    bless $self;
}


sub decode_value {
    my $self = shift;

    my $name = $_[0][0];
    if ($name =~ /^(?:nil)$/) {
        return undef;
    } else {
        my $res = $self->SUPER::decode_value( @_ );
        if ( !ref $res && !Encode::is_utf8($res) ) {
            $res = Encode::decode( $self->{yandex_encoding}, $res );
        }

        return $res;
    }
}

1;
