#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"


void internal_t10n(HV *digits, const char *key, STRLEN key_len, SV *val) {
    SvGETMAGIC(val);
    if (!SvOK(val)) {
        // пришёл undef - гичего не делаем
        return;
    }
    if (SvROK(val)) {
        // пришла ссылка, определяем тип
        SV *sv2 = SvRV(val);
        svtype sv2t = SvTYPE(sv2);

        if (sv2t == SVt_PVHV) {
            // ссылка на хэш
            hv_iterinit((HV *)sv2);
            HE *he;
            while(he = hv_iternext((HV *)sv2)) {
                internal_t10n(digits, (char *)HeKEY(he), HeKLEN(he), HeVAL(he));
            }
        } else if (sv2t == SVt_PVAV) {
            // ссылка на массив
            int len = av_len((AV *)sv2);
            int i;
            for(i = 0; i <= len; ++i) {
                SV **svp = av_fetch((AV *)sv2, i, 1);
                internal_t10n(digits, key, key_len, *svp);
            }
        } else {
            // ссылка на что-то неподдерживаемое - объект, скаляр, ...
            croak ("encountered perl type (%s,0x%x) that cannot handle, check your input data",
                   SvPV_nolen(sv2), (unsigned int)SvFLAGS(sv2));
        }
    } else {
        // проверяем, нужно ли и можно ли конвертировать в число, записываем тип
        int need_num = 0;
        if (hv_exists(digits, key, key_len)) {
            if (SvIOKp(val)) {
                need_num = SVt_IV;
            } else if (SvNOKp(val)) {
                need_num = SVt_NV;
            } else if (SvPOK(val)) {
                int lln = looks_like_number(val);
                need_num = !lln ? 0
                    : lln & IS_NUMBER_NOT_INT ? SVt_NV
                    : SVt_IV;
            }
        }

        if (SvPOK(val)) {
            // в val - строка
            if (need_num == SVt_IV) {
                SvIV(val);
                SvPOK_off(val);
            } else if (need_num == SVt_NV) {
                SvNV(val);
                SvPOK_off(val);
            }
        } else if (SvNOKp(val) || SvIOKp(val)) {
            // в val - число
            if (!need_num) {
                SvPV_nolen(val);
                SvNIOK_off(val);
            }
        } else {
            // в val - непонятно что
            croak ("encountered perl type (%s,0x%x) that cannot handle, check your input data",
                   SvPV_nolen(val), (unsigned int)SvFLAGS(val));
        }
    }
}

/* increase n for ~12% */
#define BUF_SIZE_GROW(n) (n + (n>>3))

char quotes[UCHAR_MAX];
bool quotes_inited = 0;
void inline quotes_init() {
    if (!quotes_inited) {
        size_t i;
        for(i = 0; i < UCHAR_MAX; i++) quotes[i] = 0;
        quotes[(unsigned char)'\n'] = 'n';
        quotes[(unsigned char)'\b'] = 'b';
        quotes[(unsigned char)'\f'] = 'f';
        quotes[(unsigned char)'\t'] = 't';
        quotes[(unsigned char)'\r'] = 'r';
        quotes[(unsigned char)'\''] = '\'';
        quotes[(unsigned char)'\\'] = '\\';
        quotes[0] = '0';
        quotes_inited = 1;
    }
}


void inline _buf_reserve(char **buf_ptr, size_t *buf_len_ptr, size_t capacity) {
    if (*buf_len_ptr >= capacity) {
        return;
    }
    size_t new_len = BUF_SIZE_GROW(*buf_len_ptr);
    if (new_len < capacity) {
        new_len = capacity;
    }
    *buf_ptr = (char*)realloc(*buf_ptr, new_len);
    if (!*buf_ptr) {
        croak("realloc failed");
    }
    *buf_len_ptr = new_len;
}

void quote_append(const char *str, size_t len, char **buf_ptr, size_t *pos_ptr, size_t *buf_len_ptr) {
    quotes_init();

    _buf_reserve(buf_ptr, buf_len_ptr, *pos_ptr + BUF_SIZE_GROW(len) + 3);
    
    size_t i;
    size_t j = *pos_ptr;
    char *buf = *buf_ptr;
    for (i = 0 ; i < len ; ++i) {
        /* precalculated lookup table faster than switch in 2 times */
        if (quotes[(unsigned char)str[i]]) {
            buf[j++] = '\\';
            buf[j++] = quotes[(unsigned char)str[i]];
        } else {
            buf[j++] = str[i];
        }
        if (j > *buf_len_ptr - 3) {
            _buf_reserve(buf_ptr, buf_len_ptr, 1+*buf_len_ptr);
            buf = *buf_ptr;
        }
    }
    *pos_ptr = j;
}

char* quote_impl(const char* str, size_t len, size_t* res_new_len)
{
    size_t new_len = BUF_SIZE_GROW(len) + 3;
    if (new_len < 16) {
        new_len = 16;
    }
    char* ret = (char*)malloc(new_len * sizeof(char));
    if (!ret) {
        croak("malloc failed");
    }

    size_t pos = 0;
    quote_append(str, len, &ret, &pos, &new_len);

    ret[pos] = 0;
    *res_new_len = pos;
    return ret;
}


MODULE = Yandex::XsUtils		PACKAGE = Yandex::XsUtils		


PROTOTYPES: ENABLE

void t10n(HV *digits, SV *key, SV *val)
    CODE:
    STRLEN len;
    char *key_str = SvPV(key, len);
    internal_t10n(digits, key_str, len, val);


SV*
clh_quote(sv)
    SV* sv
PROTOTYPE: $
CODE:
{
    STRLEN len;
    SV* ret;
    size_t new_len;
    char* p = SvPV(sv, len);
    int is_utf = SvUTF8(sv);
    char* quoted = quote_impl(p, len, &new_len);
    ret = newSVpvn(quoted, new_len);
    free(quoted);
    if (is_utf) {
        SvUTF8_on(ret);
    }
    RETVAL = ret;
}
OUTPUT:
    RETVAL


SV*
clh_quote_tsv_row(AV *av)
PROTOTYPE: $
CODE:
{
    size_t buf_len = 8912;
    size_t pos = 0;
    char* buf = (char*)malloc(buf_len);
    if (!buf) {
        croak("malloc failed");
    }

    int av_len = av_len(av);
    int i;
    for(i = 0; i <= av_len; ++i) {
        SV **svp = av_fetch(av, i, 1);

        if (!SvOK(*svp)) {
            // пришёл undef - заменяем на пустую строку
        } else if (SvROK(*svp)) {
            // пришла ссылка, определяем тип
            SV *av2 = SvRV(*svp);

            if (SvTYPE(av2) != SVt_PVAV) {
                croak("incorrect data for clh_quote_tsv_row - ref instead data");
            }

            _buf_reserve(&buf, &buf_len, pos+1);
            buf[pos++] = '[';
            int av2_len = av_len(av2);
            int j;
            for(j = 0; j <= av2_len; ++j) {
                SV **svp2 = av_fetch(av2, j, 1);

                if (!SvOK(*svp2)) {
                    // undef
                } else {
                    STRLEN len;
                    char* p = SvPV(*svp2, len);
                    quote_append(p, len, &buf, &pos, &buf_len);
                }

                if (j < av2_len) {
                    _buf_reserve(&buf, &buf_len, pos+1);
                    buf[pos++] = ',';
                }
            }
            _buf_reserve(&buf, &buf_len, pos+1);
            buf[pos++] = ']';
        } else {
            STRLEN len;
            char* p = SvPV(*svp, len);
            quote_append(p, len, &buf, &pos, &buf_len);
        }

        if (i < av_len) {
            _buf_reserve(&buf, &buf_len, pos+1);
            buf[pos++] = '\t';
        }
    }

    _buf_reserve(&buf, &buf_len, pos+1);
    buf[pos++] = '\n';

    SV* ret = newSVpvn(buf, pos);
    free(buf);

    //if (is_utf) {
    //    SvUTF8_on(ret);
    //}
    RETVAL = ret;
}
OUTPUT:
    RETVAL


