#!/usr/bin/perl

use common::sense;
use Benchmark qw/:all/;
use lib::abs './lib';
use lib::abs '.';
use lib::abs 'blib/arch';
use Yandex::XsUtils qw/clh_quote clh_quote_tsv_row/;

my @chars = ('a' .. 'z', (map { chr($_) } ord('а') .. ord('я')), "\r", "\n", "\t", "'");
my $str = join "", map { $chars[int rand @chars] } (1 .. 1000);
$str .= "\t" x 1000;
$str .= join "", map { $chars[int rand @chars] } (1 .. 1000);

{
    # См. http://clickhouse.yandex-team.ru/#TabSeparated
    my %quote = (
        "\x00" => "\\0",
        "\b" => "\\b",
        "\f" => "\\f",
        "\r" => "\\r",
        "\n" => "\\n",
        "\t" => "\\t",
        "'" => "\\'",
        "\\" => "\\\\",
    );

=head2 _quote

Квотирует единичное значение

=cut
    sub _quote {
        return $_[0] =~ s/[\b\f\r\n\t\x00\'\\]/$quote{$&}/gor;
    }
    
    sub _quote2 {
        return $_[0] =~ s/([\b\f\r\n\t\x00\'\\])/$quote{$1}/gr;
    }
    
}

# cmpthese(-5, {
#     xs => sub { clh_quote($str) },
#     pp1 => sub { _quote($str) },
#     pp2 => sub { _quote2($str) },
# });


# for my $i (0 .. 100_000) {
my $i = 200;
while ($i < 2**20) {
    # for (my $j = 2; $j < 2**10; $j += 10) {
    # for (my $j = 2; $j < 2**10; $j *= 2) {
    #     my @row = map { "'" x $j } (1 .. $i);
    #     print STDERR "> $i $j\n";
    #     clh_quote_tsv_row(\@row);
    # }
    $i += 10;
    # $i *= 2;
    $str = "'" x $i;
    clh_quote($str);
    # _quote($str);
}

__END__

       Rate   pp2   pp1    xs
pp2  1495/s    --   -8%  -96%
pp1  1625/s    9%    --  -96%
xs  39024/s 2509% 2301%    --
