package Yandex::XsUtils;

use 5.014002;
use strict;
use warnings;

use parent qw/Exporter/;

our $VERSION = '0.01';
our @EXPORT_OK = qw/
    t10n
    clh_quote
    clh_quote_tsv_row
/;

require XSLoader;
XSLoader::load('Yandex::XsUtils', $VERSION);



1;
__END__

=head1 NAME

Yandex::XsUtils - кучка маленьких xs-ных функций для ускорения критичных мест в Директе
Свалка всех функций в одном модуле, чтобы упростить разработку/сборку/выкладку

=head1 SYNOPSIS

  use Yandex::XsUtils;

=head1 DESCRIPTION

=head2 t10n(numeric_keys, key, value)

    Простая типизация структуры перед сериализацией в JSON (в основном для API)
    Превращает числовые ключи из словаря -- к цифровому представлению (сериализуется без кавычек), если в строке что-то похожее на число (looks_like_number)
        и остальные -- к строковому (в результате будут в кавычках).

    Аргументы:
    - numeric_keys - ссылка на хэш с ключами, которые по-возможности стоит превратить в число
    - key - ключ, по которому нужно определять, конвертировать ли value, если это скаляр
    - value - скаляр/массив/хэш не более чем вложенности 100

    Возвращаемого значения нет, value меняется in-place

=head2 clh_quote

    Функция для экранирования данных перед вставкой в ClickHouse (в формате TabSeparated)
    Делает то же самое, что и s/[\b\f\r\n\t\x00\'\\]/$quote{$&}/gor
    но в 10 раз быстрее (и чем длиннее строка - тем быстрее)

=head2 clh_quote_tsv_row

    Функция для экранирования массива значений, как tsv-строка для отправки в clickhouse
    undef-ы заменяются на пустые строки
    в конец строки добавляется \n

=cut
