use strict;
use warnings;
use utf8;

use Test::More;
BEGIN { use_ok('Yandex::XsUtils', 'clh_quote_tsv_row') };

local *qu = \&clh_quote_tsv_row;

my $r1 = "привет";
my $r2 = $r1;
utf8::encode($r2);

my @test = (
    [ [],"\n" ],
    [ [1,2,undef,"sad"],"1\t2\t\tsad\n" ],
    [ [1,2,[1,3,4],"sad"],"1\t2\t[1,3,4]\tsad\n" ],
);

for my $t (@test) {
    is(qu($$t[0]), $$t[1]);
}

done_testing();

