use strict;
use warnings;
use utf8;

use Test::More;
BEGIN { use_ok('Yandex::XsUtils', 'clh_quote') };

local *qu = \&clh_quote;

    # my %quote = (
    #     "\x00" => "\\0",
    #     "\b" => "\\b",
    #     "\f" => "\\f",
    #     "\r" => "\\r",
    #     "\n" => "\\n",
    #     "\t" => "\\t",
    #     "'" => "\\'",
    #     "\\" => "\\\\",
    # );
my $r1 = "привет";
my $r2 = $r1;
utf8::encode($r2);

my @test = (
    [ "","" ],
    [ "'''''","\\'\\'\\'\\'\\'" ],
    [ "\0","\\0" ],
    [ "\b","\\b" ],
    [ "\f","\\f" ],
    [ "\r","\\r" ],
    [ "\n","\\n" ],
    [ "\t","\\t" ],
    [ "\'","\\'" ],
    [ "\\\n", "\\\\\\n" ],
    [ "a\nb", "a\\nb" ],
    [ "\tabc", "\\tabc" ],
    [ "\\","\\\\" ],
    [ $r1."\r\n", $r1."\\r\\n" ],
    [ $r2."\r\n", $r2."\\r\\n" ],
);

for my $t (@test) {
    is(qu($$t[0]), $$t[1], $$t[1]);
}

done_testing();

