use strict;
use warnings;

use Test::More;
use Test::Exception;

use JSON::PP qw//;
use Clone qw/clone/;
use Data::Dumper qw/Dumper/;
$Data::Dumper::Indent = 0;
$Data::Dumper::Terse = 1;

BEGIN { use_ok('Yandex::XsUtils', 't10n') };

my @tests = (
    [{}, 'q', undef] => undef,
    [{q=>1}, 'q', undef] => undef,

    [{}, 'q', 1] => '1',
    [{}, 'q', 1.1] => '1.1',
    [{}, 'q', '1'] => '1',
    [{}, 'q', '1.1'] => '1.1',
    [{q=>1}, 'q', 1] => 1,
    [{q=>1}, 'q', 1.1] => 1.1,
    [{q=>1}, 'q', '1'] => 1,
    [{q=>1}, 'q', '1.1'] => 1.1,

    [{q=>1}, 'q', {q => ['1', 'a', 2], qq => ['1', 'a', 2]}] => {q => [1, 'a', 2], qq => ['1', 'a', '2']},

    [{q=>1}, 'q', ['1', '2a', {qq => ['1', 'a', 2]}]] => [1, '2a', {qq => ['1', 'a', '2']}]

    );

my $json = JSON::PP->new->canonical->allow_nonref;
for(my $i = 0; $i < @tests; $i+=2) {
    my ($args, $res) = @tests[$i, $i+1];
    my ($hash, $key, $val) = @$args;
    
    my $new_val = clone($val);
    t10n($hash, $key, $new_val);
    is($json->encode($new_val), $json->encode($res), "Args: ".Dumper($args));
}

done_testing();
