package Yandex::YaMoney;

=pod
    $Id$
    Модуль для работы с money.yandex.ru/api
    http://api.yandex.ru/money/doc/dg/concepts/About.xml
=cut

use strict;
use warnings;

use LWP::UserAgent;
use HTTP::Headers;
use JSON;
use Data::Dumper;

use Yandex::Log;

use base qw/Exporter/;

use utf8;

our $DEBUG;

our @EXPORT = qw/
    ym_validate_payment_token
/;

our $YAMONEY_API_URL ||= 'https://money.yandex.ru/api/';

our %YA_MONEY_LOG_SETTINGS;
%YA_MONEY_LOG_SETTINGS = (
    log_file_name => "ya_money_calls.log",
    date_suf => "%Y%m%d",
) if !%YA_MONEY_LOG_SETTINGS;

our $TIMEOUT ||= 5;

sub _ym_method {
    my ($method, $token, $params) = @_;
    $params ||= {};

    my $log = new Yandex::Log(
        %YA_MONEY_LOG_SETTINGS,
        msg_prefix => "[$$]",
    );

    my $res = {};
    if ($token !~ m/^[\dA-Za-z]+\.[\dA-Za-z]+$/) {
        $res->{error} = 'invalid_token';
        return $res;
    }

    my $headers = HTTP::Headers->new;
    $headers->header('Authorization' => "Bearer $token");

    my $url = $YAMONEY_API_URL.$method;


    my $ua = LWP::UserAgent->new(timeout => $TIMEOUT);
    eval {
        my $req = HTTP::Request->new('POST' => $url, $headers, Content => $params);

        my $resp = $ua->request($req);

        if ($resp->code == 301) {
            die "YaMoney method $method does not exist: ".$resp->status_line;
        } elsif($resp->code == 401) {
            $log->out("YaMoney request (method: $method) failed (invalid token): ".$resp->status_line);
            $res->{error} = 'invalid_token';
        } elsif (!$resp->is_success) {
            die "YaMoney request (method: $method) failed: ".$resp->status_line;
        } else {
            my $content_type = $resp->header('Content-Type');
            if ($content_type eq 'application/json;charset=UTF-8') {
                $res = eval {
                   JSON::from_json($resp->content);
                };
            } else {
                die "Unknown content type '$content_type'";
            }
        }
    };

    if ($@) {
        $log->out($@);
        die $@;
    } else {
        $log->out("YaMoney request (method: $method, uid: $res->{uid}) ok");
    }

    return $res;
}

=head2 ym_validate_payment_token

    Валидация платежного токена (access_token в терминах YM)
    На вход получает токет, возвращает пустую структуру (в случае некоторых ошибок) или структуру:
        uid => uid в паспорте, привязанный к токену
        scope => scope для токена в ЯД
        direct_scope => [0,1] выписан ли этот токен для оплаты Директа через API
        error => в случае ошибки, описание

=cut

sub ym_validate_payment_token($) {
    my $token = shift;

    my $res = eval { _ym_method('token-validate', $token) };
    if ($@) {
        return { error => 'ym_not_available' };
    }

    $res->{direct_scope} = 0;
    if ($res->{scope} && $res->{scope} =~ m/\syandex-direct\(/) {
        $res->{direct_scope} = 1;
    }

    return $res;
}

1;
