#!/usr/bin/perl -w

# $Id$

use strict;
use warnings;

use Test::More tests => 7;

use Data::Dumper;
use Test::Deep;
use Test::Mock::LWP qw/$Mock_resp $Mock_req/;

use_ok( 'Yandex::YacoTools' );

*up = \&Yandex::YacoTools::url_phrases;

$Mock_resp->mock( 
    content => sub { 
        my $hash = {
            "http://cnn.com" => "64f8a6defe298c20bd2bf8491b263223\t200\t0.004541:9000049 9000051:help us,0.001762:9000019:am who",
            "http://empty.cnn.com" => "12f8365681edb7ffb81dabe784e2456e\t200\t",
            
            "http://err.cnn.com" => "541ecf49299e7501acc5c5cdaf9bdaa5\t404\t0.004541:9000049 9000051:help us,0.001762:9000019:am who",
            "http://md5.cnn.com" => "e21723e6bc30a790312c9deec16bfa\t200\t0.004541:9000049 9000051:help us,0.001762:9000019:am who",
        };
        (my $url = $Mock_req->{new_args}->[4]) =~ s/\s+$//;
        return $hash->{$url} || '';
    },
    is_success => sub { return 1 },
 );

my $p;

$p = eval { up("http://cnn.com"); };
is($@, '', "Good eval");
cmp_deeply($p, [
               {rel => '0.004541', categories => [49, 51], phrase => 'help us'},
               {rel => '0.001762', categories => [19], phrase => 'am who'}
           ], "Good phrases");

$p = eval { up("http://empty.cnn.com"); };
is($@, '', "Empty eval");
cmp_deeply($p, [], "Empty phrases");

$p = eval { up("http://err.cnn.com"); };
like($@, qr/Incorrect http_status/, "http status");

$p = eval { up("http://md5.cnn.com"); };
like($@, qr/Incorrect md5/, "md5");

