package Yandex::Yamb;

use strict;
use warnings;

use Yandex::HTTP qw/http_parallel_request/;
use ProjectSpecific qw/tabula_url/;
use URI::Escape qw/uri_escape_utf8/;

use base qw/Exporter/;
our @EXPORT = qw/
    send_yamb_message
/;

use utf8;


=head2 send_yamb_message

    Отправляет сообщение в Yamb указанным пользователям, путем дергания ручки /yamb_send в табуле.

    Принимает именованные параметры:
        to -- логин получателя сообщения или ссылка на массив логинов адресатов [обязательный]
        message -- текст отправляемого сообщения [обязательный]

=cut



sub send_yamb_message
{
    my (%O) = @_;

    die 'no recipients specified' unless $O{to};
    die 'no mesuage text given' unless $O{message};
    my $recipients = ref($O{to}) eq 'ARRAY' ? $O{to} : [$O{to}];
    die 'no recipients specified' unless @$recipients;

    my $request_id = 1;
    my %requests = map { $request_id++ => { 'url' => tabula_url()."/yamb_send?to=$_&msg=".uri_escape_utf8($O{message}) } } @$recipients;
    my $responses = http_parallel_request( 'GET', \%requests);

    return $responses;

}

1;
