package Yandex::YT::Format::dsv;

sub dumps($) {
    my $rec = shift;
    return join("\t", map {escape($_).'='.escape($rec->{$_})} keys %$rec)
}

sub loads($) {
    my $line = shift;
    my %rec;
    for my $pair (split /\t/, $line) {
        # не работает с ключами, содержащими =
        my ($key, $val) = split /=/, $pair, 2;
        $rec{unescape($key)} = unescape($val);
    }
    return \%rec;
}

{
#my %escape_dict = ("\\" => "\\\\", "\n" => "\\n", "\t" => "\\t", "=" => "\\=", "\0" => "\\0");
#my $escape_chars = join '', keys %escape_dict;

#my %unescape_dict = reverse %escape_dict;
#my $unescape_re = join '|', map {quotemeta($_)} keys %unescape_dict;
my %escdict = ("\\" => "\\\\", "\n" => "\\n", "\t" => "\\t", "=" => "\\=", "\0" => "\\0", "\"" => "\\\"");
my %undict = ("\\" => "\\", "n" => "\n", "t" => "\t", "0" => "\0");

sub escape {
    (my $str = shift) =~ s/([\\\n\t\0=])/$escdict{$1}/go;
    return $str;
}

sub unescape {
    #(my $str = shift) =~ s/($unescape_re)/$unescape_dict{$1}/go;
    (my $str = shift) =~ s!\\(.)!$undict{$1} // $1!geo;
    return $str;
}
}

1;

