package Yandex::YT::TableReader;

=head1 NAME

    Yandex::YT::TableReader - чтение таблиц из YT

=head1 SYNOPSIS

    my $reader = Yandex::YT::TableReader->new('//home/direct/db/bids{id,price}[:#10]', binmode => ':utf8');
    # my $reader = Yandex::YT::TableReader->new('//home/direct/db/bids{id,price}[:#10]', format => 'json');
    while(my $rec = $reader->next()) {
        print Dumper $rec;
    }

=cut

use strict;
use warnings;

use Carp;

use Yandex::YT::Streaming;

our $DEFAULT_CONFIG = '{read_retries={enable=%true};read_progress_bar={enable=%false}}';

sub new {
    my ($cls, $file, %opt) = @_;
    my $binmode = delete $opt{binmode};
    my $format  = delete $opt{format} // $Yandex::YT::Streaming::DEFAULT_FORMAT;
    my $format_flags = delete $opt{format_flags} // $Yandex::YT::Streaming::DEFAULT_FORMAT_FLAGS->{$format} // '';
    my $config = delete $opt{config} // $DEFAULT_CONFIG;
    croak "Unsupported options: ".join(',', keys %opt) if %opt;
    open(my $fh, "-|", "yt", "read" => $file, "--format" => "<$format_flags>$format", "--config" => $config) || croak "Can't start yt read: $!";
    if ($binmode) {
        binmode($fh, $binmode) || croak "Can't set binmode: $!";
    }
    my $s = Yandex::YT::Streaming->new(in_fh => $fh, format => $format);
    bless {file => $file, fh => $fh, streaming => $s}, $cls;
}

sub next {
    my ($self) = @_;
    my $rec = $self->{streaming}->get();
    if (defined $rec) {
        return $rec;
    } else {
        close($self->{fh}) || croak "Can't close yt stream for $self->{file}: $!";
        return undef;
    }
}

1;
