package Yandex::YT::TableWriter;

=head1 NAME

    Yandex::YT::TableWriter - запись таблиц в YT

=head1 SYNOPSIS

    my $writer = Yandex::YT::TableWriter->new('//tmp/mytable', binmode => ':utf8');
    # my $writer = Yandex::YT::TableWriter->new('//tmp/mytable', format => 'json');
    for my $rec (@recs) {
        $writer->write($rec);
    }
    $writer->close();

=cut

use strict;
use warnings;

use Carp;

use Yandex::YT::Streaming;
use IPC::Open2;

sub new {
    my ($cls, $file, %opt) = @_;
    my $binmode = delete $opt{binmode};
    my $format  = delete $opt{format} // $Yandex::YT::Streaming::DEFAULT_FORMAT;
    my $format_flags = delete $opt{format_flags} // $Yandex::YT::Streaming::DEFAULT_FORMAT_FLAGS->{$format} // '';
    my $config = delete $opt{config};
    croak "Unsupported options: ".join(',', keys %opt) if %opt;

    open(my $fh, "|-", "yt", "write" => $file, "--format" => "<$format_flags>$format", ($config ? ('--config' => $config) : ())) || croak "Can't start yt write: $!";

    if ($binmode) {
        binmode($fh, $binmode) || croak "Can't set binmode: $!";
    }

    my $s = Yandex::YT::Streaming->new(out_fh => $fh, format => $format);
    bless {file => $file, fh => $fh, streaming => $s}, $cls;
}

sub write {
    my ($self, $rec) = @_;
    $self->{streaming}->yield($rec);
}

sub close {
    my $self = shift;

    close($self->{fh}) || croak "Can't close yt stream for $self->{file}: $!";
    
    return 0;
}

1;
