package Yandex::YT::Tx;

use strict;
use warnings;
use utf8;

use Carp qw/croak/;
use Yandex::Shell qw/yash_qx/;

our $VERBOSE //= 1;
our $TX_TIMEOUT //= 180_000; # 3min
our $ID;

sub tx_start {
    croak "transaction already started" if $ID;
    local $Yandex::Shell::PRINT_COMMANDS = 1 if $VERBOSE;
    $ID = yash_qx('yt', 'start-tx', ($TX_TIMEOUT ? ('--timeout' => $TX_TIMEOUT) : ())) =~ s/\s+$//r;
}


sub tx_commit {
    croak "Transaction is not started" unless $ID;
    my $tx_id = $ID;
    $ID = undef;
    local $Yandex::Shell::PRINT_COMMANDS = 1 if $VERBOSE;
    yash_qx('yt', 'commit-tx', $tx_id);
}


sub tx_abort {
    croak "Transaction is not started" unless $ID;
    my $tx_id = $ID;
    $ID = undef;
    local $Yandex::Shell::PRINT_COMMANDS = 1 if $VERBOSE;
    yash_qx('yt', 'abort-tx', $tx_id);
}    


sub tx_yt_args {
    if ($ID) {
        return "--tx" => $ID, "--ping-ancestor-txs";
    } else {
        return ();
    }
}


END {
    if ($ID) {
        local ($!, $?);
        tx_abort();
    }
}

1;
