#!/bin/bash
set -e

if [ -z $1 -o -z $2 ]; then
	echo "Usage: $0 instance new-master"
	exit 2
fi
dbname=$1
host=$2

port=$(grep 'port=' /etc/mha.d/$dbname.conf | cut -d'=' -f2 | head -1)

# check repl status
masterha_check_repl --conf=/etc/mha.d/$dbname.conf

masterha_master_switch --conf /etc/mha.d/$dbname.conf --master_state=alive --new_master_host=$host --orig_master_is_new_slave --new_master_port=$port
