#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
sys.path.insert(0, '/var/lib')

from datetime import datetime
import re
import time
import telepot
import threading
from pprint import pprint, pformat
import urllib2
import json

sys.path.append( '/usr/lib/python2.7/dist-packages' )
sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix' )

from startrek_client import Startrek

def get_token(file):
    f = open(file)
    return f.readline().strip('\n')

telegram_bot_token = get_token('/etc/direct-tokens/telegram')
startrek_token = get_token('/etc/direct-tokens/startrek')

startrek_useragent = 'Direct.Tabula'

bot = telepot.Bot(telegram_bot_token)

#THE_PERSON = 90072844 # lena-san
THE_PERSON = 90856861 # yukaba
BOT_LOGIN = "@yd_herald_bot"
OBSERVATORIUM_CE_URL = 'https://observatorium.common.yandex.ru/juggler/ce/'
OBSERVATORIUM_TAGS_URL = 'https://observatorium.common.yandex.ru/juggler/get_tags/'
MAX_EVENTS = 30

QUEUES = {
        'devsup': {
            'startrek_query': 'Queue: DIRECT Components: devsup AND Status: !Closed "Sort By": Created desc',
            },

        }


def issue_text(issue):
    return "%s %s@ (%s)\n%s\nhttps://st.yandex-team.ru/%s" % (issue.key, issue.createdBy.id, issue.status.key, issue.summary, issue.key)

def compose_message(queue, new, in_progress, report_empty=False):
    message_parts = [ u'## Статус по очереди %s' % queue ]
    if   not len(new) > 0 and not len(in_progress) > 0 and not report_empty:
        return ''
    elif not len(new) > 0 and not len(in_progress) > 0 and     report_empty:
        message_parts += [ u'-- ничего' ]
    else:
        new_text         = "\n".join([issue_text(i) for i in new]) or u'-- ничего'
        in_progress_text = "\n".join([issue_text(i) for i in in_progress]) or u'-- ничего'

        message_parts += [
                u'### Новые запросы',
                new_text,
                u'\n### В процессе',
                in_progress_text,
                ]

    message_parts += [ '-- End --' ]
    return "\n".join(message_parts)


def report_queue(queue, chat_id, report_empty=False):
    startrek = Startrek(token=startrek_token, useragent=startrek_useragent)

    query = QUEUES[queue]['startrek_query']
    issues_generator = startrek.issues.find(query)

    new = []
    in_progress = []
    for i in issues_generator:
        #print "%s %s\n" % (i.key, i.summary)
        #pprint(i.updatedAt)
        if i.status.key == 'needInfo':
            pass
        elif i.status.key == 'open':
            new += [ i ]
        else:
            in_progress += [i]
    #in_progress += [ "%s (%s)\n%s" % (i.key, i.status.key, i.summary) ]
    
    #message = "\n".join(in_progress)
    message = compose_message(queue, new = new, in_progress = in_progress, report_empty=report_empty)
    now = datetime.now()
    # диапазон 10-20 часов выбран более-менее произвольно.
    if message != '':# and now.hour >= 10 and now.hour <= 20 and now.weekday() < 5:
        #bot.sendMessage(90072844, message)
        bot.sendMessage(chat_id, message)

    return


def devsup_status(chat_id, text, cmd):
    report_queue(queue='devsup', chat_id=chat_id, report_empty=True)
    return


def golem(chat_id, text, cmd):
    tag = re.match(cmd['regexp'], text, re.I).group(1)

    req = urllib2.Request("%s?project=direct&format=json&check_tag=%%2B%s" % (OBSERVATORIUM_CE_URL, tag))
    req.add_header('Content-Type', 'application/json')

    try:
        response = json.loads(urllib2.urlopen(req).read())
    except Exception as e:
        bot.sendMessage(chat_id, u'Извините, возникла ошибка при загрузке событий из Observatorium :(')
        return

    statuses = {}
    msg = ''
    events = []
    for host, data_list in response.iteritems():
        if data_list:
            for data in data_list:
                events.append({'status' : data.items()[0][1]['status'][0], 'host' : host, 'name' : data.items()[0][0]})
                if events[-1]['status'] not in statuses:
                    statuses[events[-1]['status']] = 0
                statuses[events[-1]['status']] += 1

    if not events:
        bot.sendMessage(chat_id, u'Не найдено событий с тегом %s' % tag)
        return
     

    EVENTS_PRIORITY = {
       'CRIT': 1,
       'WARN': 2,
       'OK': 3,
    }
    
    events = sorted(events, key=lambda x: (EVENTS_PRIORITY[x['status']], x['host'], x['name']))
    
    msg = u"Информация о событиях с тэгом %s:\n" % tag
    msg += " || ".join(["%s:%s" % (status, str(statuses[status])) for status in statuses]) + "\n\n"
    
    if len(events) > MAX_EVENTS:
         msg += u"Показаны первые %s:\n\n" % (MAX_EVENTS)
         events = events[0 : MAX_EVENTS]

    msg += "\n".join(["%s %s::%s" % (event['status'], event['host'], event['name']) for event in events])
    bot.sendMessage(chat_id, msg)
    return


def golem_ls(chat_id, text, cmd):
    req = urllib2.Request(OBSERVATORIUM_TAGS_URL)
    req.add_header('Content-Type', 'application/json')

    try:
        response = json.loads(urllib2.urlopen(req).read())
    except Exception as e:
        bot.sendMessage(chat_id, u'Извините, возникла ошибка при загрузке событий из Observatorium :(')
        return

    msg = u"Juggler-тэги: \n\n%s" % ("\n".join(response))
    bot.sendMessage(chat_id, msg)
    return


def print_help(chat_id, text, cmd):
    bot.sendMessage(chat_id, u'Привет! Это @yd_herald_bot.\n\nСписок команд, которые я могу выполнить:\n' + "\n".join([u"%s - %s" % (cmd['name'], cmd['description']) for cmd in COMMANDS]))
    return


def handle_message(msg):
    content_type, chat_type, chat_id = telepot.glance(msg)
    #print(content_type, chat_type, chat_id)
    if content_type != 'text':
        return

    msg['text'] = re.sub(BOT_LOGIN, '', msg['text'])
    
    for cmd in COMMANDS:
        if re.match(cmd['regexp'], msg['text'], re.I):
            cmd['cmd'](chat_id=chat_id, text=msg['text'], cmd=cmd)
            return

    return


def periodic_report():
    report_queue(queue='devsup', chat_id=THE_PERSON, report_empty=False)
    t = threading.Timer(1800.0, periodic_report)
    t.start()
    return


COMMANDS = [
    {
     'name': '/devsup_status',
     'regexp': r'^/devsup_status\s*$',
     'description': u'узнать статус по devsup-тикетам',
     'cmd': devsup_status
    },
    {
     'name': '/golem [tag]',
     'regexp': r'^/golem\s+(.+)$',
     'description': u'узнать статистику juggler-событий по тэгу',
     'cmd': golem
    },
    {
     'name': '/golem_ls',
     'regexp': r'^/golem_ls\s*$',
     'description': u'вывести список juggler-тэгов',
     'cmd': golem_ls
    },
    {
     'name': '/help',
     'regexp': r'^/help\s*$',
     'description': u'вывести хэлп и список команд',
     'cmd': print_help
    },
]


if __name__ == '__main__':
    #print bot.getMe()

    bot.message_loop(handle_message)
    #t = threading.Timer(1800.0, periodic_report)
    #t.start()
    while 1:
        time.sleep(10)

    exit(0)

