#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys

sys.path.insert(0, '/opt')
sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix' )

import os

from yamb import Bot
from startrek_client import Startrek
import urllib2
import json
import argparse
import re
import datetime

DUTY_ID = u'-1'
WIKI_API_URL = 'https://wiki.yandex-team.ru/_api/frontend/'
WIKI_URL_FOR_TABLE = 'direct/duty/infra/'

QUEUES = {
        'devsup_open': {
            'startrek_query': 'Queue: DIRECT Components: devsup AND Status: Open "Sort By": Created desc',
            'name' : u"Новые запросы",
            },
        'devsup_in_progress': {
            'startrek_query': 'Queue: DIRECT Components: devsup AND Status: !Open Status: !Closed "Sort By": Created desc',
            'name' : u"В процессе",
            },
        }


def get_token(token_file):
    try:
        f = open(token_file)
        return f.readline().strip(u'\n')

    except Exception:
        raise Exception(u'Ошибка при чтении токена')


bot_token_file = os.environ[u'bot_token_file'] if u'bot_token_file' in os.environ else u'/etc/direct-tokens/yamb-robot-direct-notify'
st_token_file = os.environ[u'st_token_file'] if u'st_token_file' in os.environ else u'/etc/direct-tokens/startrek'

bot_token = get_token(bot_token_file)
st_token = get_token(st_token_file)

os.environ[u'REQUESTS_CA_BUNDLE'] = u'/etc/ssl/certs/'
bot = Bot(token=bot_token)


def parse_options():
    parser = argparse.ArgumentParser(formatter_class=argparse.RawDescriptionHelpFormatter,
                                     description='''Yamb-бот для оповещения разработчиков по тикетам devsup''',
                                     epilog='''
Пример использования:
  yd_herald_yamb.py --queue devsup_open
''')
    parser.add_argument('--queue', default='devsup_open', help="devsup_open или devsup_in_progress ('открытые' или 'в процессе' тикеты соотественно)")
    return vars(parser.parse_args())


def issue_text(issue):
    return "%s %s@ (%s)\n%s\nhttps://st.yandex-team.ru/%s" % (issue.key, issue.createdBy.id, issue.status.key, issue.summary, issue.key)


def compose_message(queue_output, queue, tickets, report_empty=False):
    message_parts = [u'## Статус по очереди %s' % queue]
    if not len(tickets) > 0 and not report_empty:
        return ''
    elif not len(tickets) > 0 and report_empty:
        message_parts += [u'-- ничего']
    else:
        text = "\n".join([issue_text(i) for i in tickets]) or u'-- ничего'

        message_parts += [
                u'### %s' % (queue_output),
                text,
                ]

    message_parts += ['-- End --']
    return "\n".join(message_parts)


def load_duty_table(table_url = ''):
    req = urllib2.Request(WIKI_API_URL + table_url + '/.grid?format=json')
    req.add_header('User-agent', 'direct-yamb-bot')
    req.add_header('Content-Type', 'application/json')
    req.add_header('Authorization', 'OAuth ' + st_token)
    return json.loads(urllib2.urlopen(req).read())


def get_duty_id():
    duty_table_raw_data = load_duty_table(WIKI_URL_FOR_TABLE)

    for row in duty_table_raw_data['data']['rows']:
        time_from = datetime.datetime.strptime(row[1]['raw'], '%Y-%m-%d')
        time_until = datetime.datetime.strptime(row[2]['raw'], '%Y-%m-%d')
        time_now = datetime.datetime.now()

        if time_from <= time_now <= time_until:
            for num in range(3,5):
                login = re.search('staff:(.+)', row[num]['raw'])
                if login:
                    return get_uid_by_login(login.group(1))

    return u'-1'


def get_uid_by_login(login):
    try:
        req = urllib2.Request('https://staff-api.yandex-team.ru/v3/persons?_one=1&_fields=uid&login=%s' % (login))
        req.add_header('User-agent', 'direct-yamb-bot')
        req.add_header('Authorization', 'OAuth %s' % (st_token))
        return json.loads(urllib2.urlopen(req).read())['uid']

    except:
        return DUTY_ID


def report_queue(queue, report_empty=False):
    startrek = Startrek(token=st_token, useragent=u'direct-yamb-bot')

    query = QUEUES[queue]['startrek_query']
    issues_generator = startrek.issues.find(query)

    tickets = []
    uids = set()

    for i in issues_generator:
        if i.status.key == 'needInfo':
            continue

        uid = DUTY_ID
        if i.assignee:
            uid = get_uid_by_login(i.assignee.login)
        uids.add(uid)

        tickets += [{"ticket" : i, "uid" : uid}]

    uids = list(uids)

    for uid in uids:
        if uid == u'-1':
            continue

        message = compose_message(QUEUES[queue]['name'],
                                  queue,
                                  tickets=[ticket["ticket"] for ticket in tickets if ticket["uid"] == uid],
                                  report_empty=report_empty,
                                  )

        bot.send_message(
            user_id=uid,
            organization_id=34,
            text=message,
        )

    return


def run():
    global DUTY_ID
    DUTY_ID = get_duty_id()
    options = parse_options()
    report_queue(queue=options['queue'], report_empty=False)


if __name__ == '__main__':
    run()