#!/bin/sh
export PATH=/usr/local/go/bin:$PATH

TARGET=
if [ -z "$GOPATH" ]; then
	if [ -d debian/zfs-utils ]; then
		D=$(pwd)/debian/zfs-utils/go
		mkdir -p $D
	else
		D=$(mktemp -d)
	fi
	trap "rm -rf $D" EXIT
	export GOPATH=$D
	rsync -a --exclude debian/ ./src/ $D/
	TARGET=$(pwd)
	cd $D
fi

go get
GOOS=linux GOARCH=amd64 go build -o $TARGET/bin/zfsctl
