package ZkDbConfig::type::dbtools;

use strict;
use warnings;

use base qw/ZkDbConfig::type::base/;
use Yandex::DBTools;
use JSON;

sub check {
    my ($self, $cont) = @_;
    %Yandex::DBTools::DB_CONFIG = eval { %{from_json($cont)->{db_config}} };
    if ($@) {
        return ("from_json error: $@");
    } else {
        return ();
    }
}

sub args_edit {
    my ($self, $cont, $args) = @_;
    
    if (@$args > 2) {
        die "Usage: $0 ... dbname host:port";
    }
    
    my $db = $args->[0];
    (my $db_path = $db) =~ s/:/.CHILDS./g;

    local %Yandex::DBTools::DB_CONFIG = %{from_json($cont)->{db_config}};
    my $conf = get_db_config($db);
    my ($host, $port) = ($conf->{host}, $conf->{port});

    print "Current state: $host:$port\n";

    if (@$args > 1) {
        if ($args->[1] =~ /^([\w\-\.\[\]\,]*)(?::(\d+))?/) {
            my @todo;
            if ($1) {
                $host = $1;
                push @todo, "--json", "db_config.CHILDS.$db_path.host", $1;
            }
            if ($2) {
                $port = $2;
                push @todo, "--json", "db_config.CHILDS.$db_path.port", $2;
            }
            print "New state: $host:$port\n";
            return @todo;
        } else {
            die "Incorrect new state: '$args->[1]'";
        }
    }
    return ();
}

1;
