package ZkDbConfig::type::external;

use strict;
use warnings;

use Carp;

use Yandex::Shell;

use base qw/ZkDbConfig::type::base/;

sub check {
    my ($self, $cont) = @_;

    my $cmd = 
"$self->{external_checker} <<'EOF' 2>&1
$cont
EOF
";
    my $out = `$cmd`;

    if ($? != 0) {
        $out ||= 'error';
        return ($out);
    } else {
        return ();
    }
}


sub args_edit {
    my ($self, $cont, $args) = @_;

    croak "external_editor is not defined" if !$self->{external_editor};
    
    my $ARGS_STR = join ' ', map {yash_quote($_)} @$args;

    my $cmd = 
"$self->{external_editor} $ARGS_STR <<'EOF' 2>&1
$cont
EOF
";

    my $out = `$cmd`;
    croak "Error while executing $self->{external_editor}: $? $! $out" if $? != 0;

    if (my $err = $self->check($out)) {
        croak "Check error: $err";
    }

    return \$out;
}

1;
