#!/usr/bin/python
# -*- encoding: utf-8; -*-

import os.path
import os
import sys
import logging
import time
import optparse
import yaml
import zookeeper

from zkdelivery import zk_sync_init

def parse_options():
    # парсим опции
    usage = "usage: zk-delivery-get -c config-filename zk-node-name\n" \
          + "       zk-delivery-set -c config-filename zk-node-name local-file\n"
    parser = optparse.OptionParser(usage=usage)
    parser.add_option("-c", "--config",
                  action="store", dest="config",
                  help="Config filename")
    options, args = parser.parse_args()
    return parser, options, args

def check_options(parser, options, args):
    if options.config == None:
        parser.error("Config is not defined")
    elif not os.path.exists(options.config):
        parser.error("Config file does not exists");
    if len(args) not in [1, 2]:
        parser.error("Incorrect arguments")

def set_logging(log=None):
    oldmask = os.umask(0)
    logfh = open(log, 'a', 0666) if log else sys.stderr
    os.umask(oldmask)

    logging.basicConfig(stream=logfh,
                        level=logging.ERROR,
                        format='%(asctime)s ['+str(os.getpid())+'] %(levelname)s %(message)s'
                        )
    zookeeper.set_debug_level(zookeeper.LOG_LEVEL_ERROR)
    zookeeper.set_log_stream(logfh)

def main():
    # парсим опции
    parser, options, args = parse_options()
    check_options(parser, options, args)

    conf = yaml.safe_load(open(options.config))
    set_logging()

    zkh = zk_sync_init(conf['servers'], None, 1000)
    if 'auth' in conf:
        zookeeper.add_auth(zkh, 'digest', conf['auth'], None)

    node = args[0]
    cont, _ = zookeeper.get(zkh, node)

    if len(args) == 1:
        sys.stdout.write(cont)
    else:
        open(args[1], "w").write(cont)

if __name__ == '__main__':
    main()
