#!/usr/bin/python
# -*- encoding: utf-8; -*-

import os.path
import os
import time
import optparse
import yaml
import logging


DEFAULT_MAX_AGE = 60


def main():
    # парсим опции
    usage = "usage: zk-delivery-hooks-mon -c config-filename"
    parser = optparse.OptionParser(usage=usage)
    parser.add_option("-c", "--config",
                      action="store", dest="config",
                      help="Config filename")
    parser.add_option("-m", "--max-age",
                      default=DEFAULT_MAX_AGE, type="int",
                      action="store", dest="max_age",
                      help="Hooks max run time (age of status file)")
    (options, args) = parser.parse_args()
    if args:
        parser.error("Extra arguments defined: ")
    elif options.config == None:
        parser.error("Config is not defined")
    elif not os.path.exists(options.config):
        parser.error("Config file does not exists");

    conf = yaml.safe_load(open(options.config))

    failed_hooks = []
    for finfo in conf['files']:
        if 'hooks_status_file' not in finfo or not finfo['hooks_status_file']:
            continue
        f = finfo['hooks_status_file']
        if not os.path.exists(f):
            continue
        if 'failed' in open(f, 'r').read() or time.time() - os.stat(f).st_mtime > options.max_age:
            failed_hooks.append(finfo['file'])

    if failed_hooks:
        print("2;Some hooks failed for %s" % ','.join(failed_hooks))
    else:
        print('0;Ok')


if __name__ == '__main__':
    main()
