#!/usr/bin/env python
# -*- encoding: utf-8 -*-

import yaml, sys, re

yconf = yaml.load(sys.stdin)

mon_port_to_app = {}
http_port_to_app = {}

for app, app_conf in yconf['apps'].items():
    if not isinstance(app_conf.get('monitoring_port', 0), int):
        print 'monitoring port for app %s is not integer' % app
        sys.exit(1)

    # нулевой порт (=нет порта) не обязан быть уникальным, пропускаем
    if app_conf.get('monitoring_port') == 0:
        continue

    if app_conf.get('monitoring_port') in mon_port_to_app:
        print 'monitoring port %d in app %s is same as monitoring port in app %s' % (app_conf['monitoring_port'], app, mon_port_to_app[app_conf['monitoring_port']])
        sys.exit(1)
    elif 'monitoring_port' in app_conf and app not in ['java-b2yt']:
        mon_port_to_app[app_conf['monitoring_port']] = app

sys.exit(0)
