#!/usr/bin/env python
# -*- encoding: utf-8 -*-

import yaml, sys

"""
Убеждаемся, что к одному vhost всё про ssl приезжает из одного секрета
"""

yconf = yaml.load(sys.stdin)

for vhost in yconf['vhosts']:
    vhost_conf = yconf['vhosts'][vhost]
    if 'ssl-certs' not in vhost_conf:
        continue
    ssl_secrets = {}
    for s in vhost_conf['ssl-certs']:
        ssl_secrets[s['secret_id']] = 1

    if len(ssl_secrets.keys()) > 1: 
        print "ERROR: vhost_conf, too many secrets for ssl: %s" % ssl_secrets
        sys.exit(1)

sys.exit(0)

