#!/usr/bin/env python
# -*- encoding: utf-8 -*-

import yaml, sys, re

yconf = yaml.load(sys.stdin)

def check_data(data):
    if isinstance(data, dict):
        results = []
        for key, value in data.items():
            results.append(check_data(key))
        return all(results)
    elif isinstance(data, str):
        res = bool(re.match('^[A-Za-z_][A-Za-z_0-9]*$', data))
        # print data, res
        return res

for vhost, vconf in yconf['vhosts'].items():
    if not check_data(vconf):
        sys.exit(1)

sys.exit(0)
