# -*- coding: utf-8 -*-
'''
Приехало вместе с draftsman.
Данный модуль скорее всего не нужен.
'''

from collections import defaultdict


class Aggregator(object):
    '''
    Считаем, аггрегируем...
    '''

    def calculate(self, item_data, computing):
        return dict([(k, computing(v)) for k, v in item_data.iteritems()])

    def aggregate(self, data, computings):
        grouped_items = self.group_items(data)
        agg_data = {}

        for computing in computings:
            for item, result in self.calculate(grouped_items, computing).iteritems():
                agg_data['.'.join([item, computing.name])] = result

        return agg_data

    def group_items(self, data):
        pass


class JsrenderAggregator(Aggregator):
    def aggregate(self, data, computings):
        grouped_data = self.group_items(data)
        agg_data = {}

        for name, times in grouped_data.items():
            agg_data[name + '.cnt'] = len(times)
            agg_data[name + '.avg'] = sum(times) / len(times)
            times = sorted(times)
            for proc in [50, 80, 90, 95, 99]:
                agg_data[name + '.proc_' + str(proc)] = times[int(len(times) * proc / 100)]

        return agg_data

    def group_items(self, data):
        grouped_data = defaultdict(list)
        for line in data:
            for name in ['dom-ready', 'bem-init-time', 'window-loaded']:
                if name in line and isinstance(line[name], int):
                    norm_name = name.replace('-', '_')
                    grouped_data[line['controller'] + '.' + norm_name].append(line[name])
                    grouped_data['_all_requests' + '.' + norm_name].append(line[name])

        return grouped_data


class MrateAggregator(Aggregator):
    def __init__(self, counts=None, **kwargs):
        self.counts = counts or []

    def group_items(self, grouped_data):
        result = {
            'errors': 0,
            'response_time': [],
            'retries': 0,
            'timeouts': 0,
            'total': 0,
        }

        for item in grouped_data:
            for key in self.counts:
                result[key] += item[key]
            result['response_time'].extend(item['response_time'])

        return {'mrate': result}
