# -*- coding: utf-8 -*-
'''
Приехало вместе с draftsman.
Данный модуль скорее всего не нужен.
'''

from __future__ import division


class Computing(object):
    '''
    Базовый класс для вычислителей.
    '''

    def __init__(self, name, func=None):
        '''
        Constructor
        '''
        self.name = name

        self.__func = func

    def calculate(self, data):
        if self.__func is not None:
            return self.__func(data)
        else:
            return data

    def __call__(self, data):
        return self.calculate(data)

    def __str__(self, *args, **kwargs):
        return self.name

    def __unicode__(self):
        return self.__str__()


class Count_(Computing):
    '''
    Подсчёт количества.
    '''
    def __init__(self, name, code=None):
        super(Count_, self).__init__(name)
        self.code = code

    def calculate(self, data):
        if self.code is not None:
            data = filter(lambda _: _['response_code'] == self.code, data)

        return len(data)


class Percentile(Computing):
    '''
    Перцентиль
    '''

    def __init__(self, name, percent, step=1.2):
        super(Percentile, self).__init__(name)
        self.percent = percent
        self.step = step

    def calculate(self, data):
        total = len(data)
        fraction = total * self.percent / 100
        prepared_data = {}

        for t in data:
            rt = round(t['response_time'], 2)
            prepared_data[rt] = prepared_data.get(rt, 0) + 1

        data_pairs = sorted(prepared_data.items())
        threshold = 0
        counter = 0

        for pair in data_pairs:
            counter += pair[1]

            if counter <= fraction:
                threshold = pair[0]
            else:
                break

        return threshold


CMP_COUNT = Count_('cnt')
CMP_COUNT_2XX = Count_('cnt_2xx', '2xx')
CMP_COUNT_3XX = Count_('cnt_3xx', '3xx')
CMP_COUNT_4XX = Count_('cnt_4xx', '4xx')
CMP_COUNT_5XX = Count_('cnt_5xx', '5xx')

CMP_AVG = Computing('avg', func=lambda _: sum(x['response_time'] for x in _) / len(_))

CMP_SUM = Computing('sum', func=lambda _: sum(x['response_time'] for x in _))

CMP_PROC_80 = Percentile('proc80', 80)
CMP_PROC_90 = Percentile('proc90', 90)
CMP_PROC_95 = Percentile('proc95', 95)
CMP_PROC_98 = Percentile('proc98', 98)
CMP_PROC_99 = Percentile('proc99', 99)
CMP_PROC_100 = Percentile('proc100', 100)
